@extends('admin.layouts.app')

@push('libraries_top')

@endpush

@section('content')
    <section class="section">
        <div class="section-header">
            <h1>{{ trans('update.bundles') }} {{trans('admin/main.list')}}</h1>
            <div class="section-header-breadcrumb">
                <div class="breadcrumb-item active"><a href="{{ getAdminPanelUrl() }}">{{trans('admin/main.dashboard')}}</a>
                </div>
                <div class="breadcrumb-item">{{ trans('update.bundles') }}</div>
            </div>
        </div>

        <div class="section-body">

            <div class="row">
                <div class="col-lg-3 col-md-6 col-sm-6 col-12">
                    <div class="card card-statistic-1">
                        <div class="card-icon bg-primary">
                            <i class="fas fa-cube"></i>
                        </div>
                        <div class="card-wrap">
                            <div class="card-header">
                                <h4>{{trans('admin/main.total')}} {{ trans('update.bundles') }}</h4>
                            </div>
                            <div class="card-body">
                                {{ $totalBundles }}
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6 col-sm-6 col-12">
                    <div class="card card-statistic-1">
                        <div class="card-icon bg-warning">
                            <i class="fas fa-eye"></i>
                        </div>

                        <div class="card-wrap">
                            <div class="card-header">
                                <h4>{{trans('admin/main.pending_review')}} {{ trans('update.bundles') }}</h4>
                            </div>
                            <div class="card-body">
                                {{ $totalPendingBundles }}
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-lg-3 col-md-6 col-sm-6 col-12">
                    <div class="card card-statistic-1">
                        <div class="card-icon bg-success">
                            <i class="fas fa-dollar-sign"></i></div>
                        <div class="card-wrap">
                            <div class="card-header">
                                <h4>{{trans('admin/main.total_sales')}}</h4>
                            </div>
                            <div class="card-body">
                                {{ !empty($totalSales) ? number_format($totalSales->total_amount, 2) : 0 }}
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-lg-3 col-md-6 col-sm-6 col-12">
                    <div class="card card-statistic-1">
                        <div class="card-icon bg-info">
                            <i class="fas fa-shopping-cart"></i></div>
                        <div class="card-wrap">
                            <div class="card-header">
                                <h4>{{trans('admin/main.total_orders')}}</h4>
                            </div>
                            <div class="card-body">
                                {{ !empty($totalSales) ? $totalSales->sales_count : 0 }}
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <section class="card">
                <div class="card-body">
                    <form method="get" class="mb-0">
                        <div class="row">
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="input-label">{{trans('admin/main.search')}}</label>
                                    <input name="title" type="text" class="form-control" value="{{ request()->get('title') }}">
                                </div>
                            </div>

                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="input-label">{{trans('admin/main.start_date')}}</label>
                                    <div class="input-group">
                                        <input type="date" id="from" class="text-center form-control" name="from" value="{{ request()->get('from') }}" placeholder="Start Date">
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="input-label">{{trans('admin/main.end_date')}}</label>
                                    <div class="input-group">
                                        <input type="date" id="to" class="text-center form-control" name="to" value="{{ request()->get('to') }}" placeholder="End Date">
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="input-label"></label>
                                    <button class="btn btn-primary btn-block" type="submit">{{trans('admin/main.search')}}</button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </section>

            <div class="row">
                <div class="col-12">

                    <div class="card">
                        <div class="card-header">
                            <h4>{{ trans('update.bundles') }}</h4>

                            <div class="card-header-action">
                                <a href="{{ getAdminPanelUrl() }}/bundles/create" class="btn btn-primary"><i class="fas fa-plus"></i> {{trans('admin/main.new')}}</a>
                            </div>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-hover">
                                    <thead>
                                    <tr>
                                        <th>{{trans('admin/main.id')}}</th>
                                        <th>{{trans('public.title')}}</th>
                                        <th>{{trans('admin/main.teacher')}}</th>
                                        <th>{{trans('admin/main.category')}}</th>
                                        <th>{{trans('admin/main.courses')}}</th>
                                        <th>{{trans('admin/main.price')}}</th>
                                        <th>{{trans('admin/main.sales')}}</th>
                                        <th>{{trans('admin/main.status')}}</th>
                                        <th>{{trans('admin/main.actions')}}</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @forelse($bundles as $bundle)
                                        <tr>
                                            <td>{{ $bundle->id }}</td>
                                            <td>
                                                <a href="{{ getAdminPanelUrl() }}/bundles/{{ $bundle->id }}/edit">{{ $bundle->title }}</a>
                                            </td>
                                            <td>{{ $bundle->teacher->full_name ?? '-' }}</td>
                                            <td>{{ $bundle->category->title ?? '-' }}</td>
                                            <td><span class="badge badge-info">{{ $bundle->bundle_webinars_count ?? 0 }}</span></td>
                                            <td>{{ number_format($bundle->price ?? 0, 2) }}</td>
                                            <td>
                                                {{ $bundle->sales->count() }}
                                            </td>
                                            <td>
                                                @if($bundle->status == \App\Models\Bundle::$active)
                                                    <span class="badge badge-success">{{trans('admin/main.active')}}</span>
                                                @elseif($bundle->status == \App\Models\Bundle::$pending)
                                                    <span class="badge badge-warning">{{trans('admin/main.pending')}}</span>
                                                @else
                                                    <span class="badge badge-danger">{{trans('admin/main.inactive')}}</span>
                                                @endif
                                            </td>
                                            <td>
                                                <a href="{{ getAdminPanelUrl() }}/bundles/{{ $bundle->id }}/edit" class="btn btn-sm btn-info" title="{{trans('admin/main.edit')}}"><i class="fas fa-edit"></i></a>
                                                <a href="{{ getAdminPanelUrl() }}/bundles/{{ $bundle->id }}/delete" class="btn btn-sm btn-danger delete-action" title="{{trans('admin/main.delete')}}"><i class="fas fa-trash"></i></a>
                                            </td>
                                        </tr>
                                    @empty
                                        <tr>
                                            <td colspan="100%" class="text-center">
                                                <p class="text-muted">{{trans('admin/main.no_result_found')}}</p>
                                            </td>
                                        </tr>
                                    @endforelse
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <div class="card-footer text-right">
                            {{ $bundles->appends(request()->query())->links() }}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

@endsection

@push('scripts_bottom')

@endpush
