/******/ (() => { // webpackBootstrap
var __webpack_exports__ = {};
/*!***********************************************************!*\
  !*** ./resources/js/admin/create_certificate_template.js ***!
  \***********************************************************/
(function () {
  "use strict";

  function syncContentToForm() {
    $('.js-template-contents').val($('#certificateTemplateContainer').html());
  }
  function applyDraggable() {
    $(".draggable-element").draggable({
      containment: ".certificate-template-container",
      stop: function stop(event, ui) {
        syncContentToForm();
      }
    });
  }
  $(document).ready(function () {
    applyDraggable();
  });
  function removeDragElement(name) {
    $('.certificate-template-container').find('.draggable-element[data-name="' + name + '"]').remove();
  }
  function makeDragElement($accordion, name) {
    var _$element$css, _$element$css2;
    //removeDragElement(name);

    var content = $accordion.find('.js-element-content').val();
    var fontSize = $accordion.find('.js-element-font_size').val();
    var fontColor = $accordion.find('.js-element-font_color').val();
    var fontBold = $accordion.find('.js-element-font_weight_bold').is(":checked");
    var textCenter = $accordion.find('.js-element-text_center').is(":checked");
    var textRight = $accordion.find('.js-element-text_right').is(":checked");
    var $element = $(".draggable-element[data-name=\"".concat(name, "\"]"));
    if ($element.length < 1) {
      $element = $("<div class=\"draggable-element\" data-name=\"".concat(name, "\"></div>"));
      $('.certificate-template-container').append($element);
    }
    var textAlign = textCenter ? 'center' : textRight ? 'right' : 'inherit';
    var fontWeight = fontBold ? 'bold' : 'inherit';
    var styles = "";
    var top = (_$element$css = $element.css("top")) !== null && _$element$css !== void 0 ? _$element$css : 0;
    var left = (_$element$css2 = $element.css("left")) !== null && _$element$css2 !== void 0 ? _$element$css2 : 0;
    if (name === "platform_signature" || name === "stamp") {
      var $image = $accordion.find('.js-element-image');
      var prefix = $image.attr("data-prefix");
      var src = $image.val();
      content = "<img src=\"".concat(prefix + src, "\" style=\"max-height: 100%; max-width: 100%;\"/>");
      styles += "display: flex; align-items: center; justify-content: center;";
    }
    $element.html(content);
    styles += "top: ".concat(top, ";");
    styles += "left: ".concat(left, ";");
    styles += "font-size: ".concat(fontSize, ";");
    styles += "color: ".concat(fontColor, ";");
    styles += "text-align: ".concat(textAlign, ";");
    styles += "font-weight: ".concat(fontWeight, ";");
    var extraStyles = $accordion.find('.js-element-styles').val();
    styles = styles + (extraStyles ? extraStyles : '');
    $element.css('cssText', styles);
    if (name === "qr_code" || name === "platform_signature" || name === "stamp") {
      var size = $accordion.find('.js-element-image_size option:checked').val();
      if (size) {
        $element.css('width', size);
        $element.css('height', size);
      }
    }
    applyDraggable();
  }
  function afterChange($accordion, checked) {
    var elementName = $accordion.attr('data-element');
    var $statusBadge = $accordion.find('.js-status-element');
    if (checked) {
      makeDragElement($accordion, elementName);
      $statusBadge.removeClass('d-none');
    } else {
      removeDragElement(elementName);
      $statusBadge.addClass('d-none');
    }
    syncContentToForm();
  }
  $('body').on('change', '.js-element-enable', function () {
    var checked = this.checked;
    var $accordion = $(this).closest('.accordion-row');
    afterChange($accordion, checked);
  });
  $('body').on('keyup change', '.js-changeable-element-input', function () {
    var $accordion = $(this).closest('.accordion-row');
    var checked = $accordion.find('.js-element-enable').is(":checked");
    afterChange($accordion, checked);
  });
  $('body').on('change', '.js-certificate-image', function (e) {
    e.preventDefault();
    var prefix = $(this).attr('data-prefix');
    prefix = prefix.replaceAll('\\', "/");
    var path = prefix + $(this).val();
    $('.certificate-template-container').css('background-image', "url('" + path + "')");
    syncContentToForm();
  });
})(jQuery);

/*
(function ($) {
"use strict";

$('body').on('click', '#preview', function (e) {
    e.preventDefault();

    const form = $('#templateForm');
    const action = $(this).attr('data-action');

    form.attr('target', '_blank');
    form.attr('action', action);
    form.attr('method', 'post');
    form.trigger('submit');
});

$('body').on('click', '#submiter', function (e) {
    e.preventDefault();

    const form = $('#templateForm');
    const action = $(this).attr('data-action');

    form.removeAttr('target');
    form.attr('action', action);
    form.attr('method', 'post');
    form.trigger('submit');
});

$('body').on('change', '.js-certificate-image', function (e) {
    e.preventDefault();

    $('.note-editable').css('background-image', 'url("' + $(this).val() + '")');
});
})(jQuery);
*/
/******/ })()
;